/*
   En setup():
   1) Realiza N mediciones consecutivas, mide tiempo total y calcula velocidad de muestreo (muestras/seg)
   2) Imprime N valores reales del ADC:
           tiempo_us    lectura

*/

const uint8_t canal = 0;    // A0
const uint16_t N = 500;     // cantidad de mediciones en ambos bloques

// --------------------------------------------------------------
// PARAMETRO A MODIFICAR
// --------------------------------------------------------------
uint16_t prescalerSeleccionado = 128;   // elegir: 128, 64, 32, 16, 8, 4, 2
// --------------------------------------------------------------


// ------------ Lectura directa ADC 10 bits ------------
uint16_t leerADC_10bits() {
  ADCSRA |= (1 << ADSC);          // iniciar conversión
  while (ADCSRA & (1 << ADSC));   // esperar
  return (ADCL | (ADCH << 8));    // leer 10 bits
}


// ------------ Configurar el prescaler ------------
void setPrescaler(uint16_t presc){
  ADCSRA &= ~((1<<ADPS2)|(1<<ADPS1)|(1<<ADPS0));
  switch (presc) {
    case 2:   ADCSRA |= (1<<ADPS0); break;
    case 4:   ADCSRA |= (1<<ADPS1); break;
    case 8:   ADCSRA |= (1<<ADPS1)|(1<<ADPS0); break;
    case 16:  ADCSRA |= (1<<ADPS2); break;
    case 32:  ADCSRA |= (1<<ADPS2)|(1<<ADPS0); break;
    case 64:  ADCSRA |= (1<<ADPS2)|(1<<ADPS1); break;
    case 128: ADCSRA |= (1<<ADPS2)|(1<<ADPS1)|(1<<ADPS0); break;
  }
}


// =============================================================
void setup() {
  Serial.begin(115200);
  delay(300);

  // Configuración del ADC
  ADMUX = (1 << REFS0);   // referencia AVcc
  ADCSRA = (1 << ADEN);   // habilitar ADC

  // Aplicar prescaler elegido
  setPrescaler(prescalerSeleccionado);

  // =============================================================
  // MEDIR VELOCIDAD DEL ADC
  // =============================================================
  Serial.println("# VELOCIDAD_ADC");
  Serial.print("# Prescaler = ");
  Serial.println(prescalerSeleccionado);

  uint32_t t0 = micros();

  for (uint16_t i = 0; i < N; i++) {
    leerADC_10bits();
  }

  uint32_t t1 = micros();

  float dt_s = (t1 - t0) / 1e6;
  float fs = N / dt_s;

  Serial.print("# Tiempo total (s) = ");
  Serial.println(dt_s, 6);
  Serial.print("# Velocidad (muestras/s) = ");
  Serial.println(fs, 1);

  Serial.println("# -------------------------------------");


  // =============================================================
  // IMPRIMIR N VALORES REALES
  // =============================================================
  Serial.println("# VALORES_ADC");
  Serial.println("# tiempo_us    lectura");

  for (uint16_t i = 0; i < N; i++) {
    uint32_t t = micros();
    uint16_t v = leerADC_10bits();

    Serial.print(t);
    Serial.print("    ");
    Serial.println(v);
  }

  while(1);   // Fin del programa
}

void loop() {}