/*
   En setup():
     1) N lecturas directas con resolucion predefinida
     2) N lecturas con analogRead()
   Se imprimen columnas:
        tiempo_us    valor
*/

const uint8_t canal = 0;   
const uint16_t N = 500;

// =====================================================
// PARAMETRO A MODIFICAR
// =====================================================
uint8_t resolucionBits = 8;   // elegir: 10, 8, 6 o 4 bits
// =====================================================


// -------- Lectura directa 10 bits --------
uint16_t leerADC_10bits() {
  ADCSRA |= (1 << ADSC);
  while (ADCSRA & (1 << ADSC));
  return (ADCL | (ADCH << 8));
}

// -------- Lectura directa 8 bits --------
uint8_t leerADC_8bits() {
  ADCSRA |= (1 << ADSC);
  while (ADCSRA & (1 << ADSC));
  return ADCH;  
}

// =====================================================
void setup() {
  Serial.begin(115200);
  delay(300);

  // Configuración general del ADC
  ADCSRA = (1 << ADEN) | (1<<ADPS2)|(1<<ADPS1)|(1<<ADPS0); // prescaler 128

  // -----------------------------------------------------
  // CONFIGURAR ADC SEGÚN RESOLUCIÓN SOLICITADA
  // -----------------------------------------------------
  if (resolucionBits == 10) {
    ADMUX = (1 << REFS0);            // AVcc, ADLAR=0
  } 
  else { 
    ADMUX = (1 << REFS0) | (1 << ADLAR);  // AVcc, ADLAR=1 para usar ADCH
  }

  // ==========================================================
  // 1) LECTURAS DIRECTAS
  // ==========================================================
  Serial.print("# REGISTRO_");
  Serial.println(resolucionBits);
  Serial.println("# tiempo_us    valor");

  for (uint16_t i = 0; i < N; i++) {

    uint32_t t = micros();
    uint16_t v;

    if (resolucionBits == 10) {
      v = leerADC_10bits();
    }
    else {
      uint8_t v8 = leerADC_8bits();   // lectura base de 8 bits
      if      (resolucionBits == 8) v = v8;
      else if (resolucionBits == 6) v = v8 >> 2;
      else if (resolucionBits == 4) v = v8 >> 4;
      else v = v8; // fallback
    }

    Serial.print(t);
    Serial.print("    ");
    Serial.println(v);
  }

  // ==========================================================
  // 2) LECTURA CON analogRead()
  // ==========================================================
  ADMUX = (1 << REFS0);  // restaurar formato estándar
  Serial.println("# ANALOGREAD");
  Serial.println("# tiempo_us    valor");

  for (uint16_t i = 0; i < N; i++) {
    uint32_t t = micros();
    uint16_t v = analogRead(canal);

    Serial.print(t);
    Serial.print("    ");
    Serial.println(v);
  }

  // FIN
  while(1);
}

void loop() {}